@extends('admin.layout.master')
@section('import-css')
    <link href="{{ asset('assets/admin/css/bootstrap-fileinput.css') }}" rel="stylesheet">
@stop
@section('body')
    <div class="card">
        <div class="card-header bg-white font-weight-bold">
            <h4>{{$page_title}}</h4>
        </div>

        <form class="form-horizontal" method="post" role="form" enctype="multipart/form-data">
            {!! csrf_field() !!}
            <div class="card-body">

                <div class="form-group{{ $errors->has('about_title') ? ' has-error' : '' }}">
                    <label class="col-md-12"><strong style="text-transform: uppercase;">About Title</strong></label>
                    <div class="col-md-12">
                        <input type="text" class="form-control form-control-lg" name="about_title" value="{{ $basic->about_title }}">
                        @if ($errors->has('about_title'))
                            <span class="help-block">
                                <strong>{{ $errors->first('about_title') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>
                <br>

                <div class="form-group{{ $errors->has('about') ? ' has-error' : '' }}">
                    <label class="col-md-12"><strong style="text-transform: uppercase;">About Details</strong></label>
                    <div class="col-md-12">
                        <textarea id="area1" class="form-control form-control-lg" rows="10" name="about">{{ $basic->about }}</textarea>
                        @if ($errors->has('about'))
                            <span class="help-block">
                                            <strong>{{ $errors->first('about') }}</strong>
                                        </span>
                        @endif
                    </div>
                </div>
                <br>

                <div class="form-group">
                    <div class="col-md-6">
                        <strong class="text-uppercase"> Thumbnail</strong>
                    </div>

                    <div class="col-md-12">
                        <div class="fileinput fileinput-new" data-provides="fileinput">
                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;"
                                 data-trigger="fileinput">
                                <img style="width: 200px" src="{{asset('assets/images/about-video-image.jpg')}}"
                                     alt="...">
                            </div>
                            <div class="fileinput-preview fileinput-exists thumbnail"
                                 style="max-width: 200px; max-height: 150px"></div>
                            <div>
                                                <span class="btn btn-info btn-file">
                                                    <span class="fileinput-new bold uppercase"><i
                                                                class="fa fa-file-image-o"></i> Select image</span>
                                                    <span class="fileinput-exists bold uppercase"><i
                                                                class="fa fa-edit"></i> Change</span>
                                                    <input type="file" name="image" accept="image/*">
                                                </span>
                                <a href="#" class="btn btn-danger fileinput-exists bold uppercase"
                                   data-dismiss="fileinput"><i class="fa fa-trash"></i> Remove</a>
                            </div>
                        </div>
                        @if ($errors->has('image'))
                            <div class="error">{{ $errors->first('image') }}</div>
                        @endif
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-md-6">
                        <strong class="text-uppercase"> Video Background Image </strong>
                    </div>

                    <div class="col-md-12">
                        <div class="fileinput fileinput-new" data-provides="fileinput">
                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;"
                                 data-trigger="fileinput">
                                <img style="width: 200px" src="{{asset('assets/images/video-bg.jpg')}}"
                                     alt="...">
                            </div>
                            <div class="fileinput-preview fileinput-exists thumbnail"
                                 style="max-width: 200px; max-height: 150px"></div>
                            <div>
                                                <span class="btn btn-info btn-file">
                                                    <span class="fileinput-new bold uppercase"><i
                                                                class="fa fa-file-image-o"></i> Select image</span>
                                                    <span class="fileinput-exists bold uppercase"><i
                                                                class="fa fa-edit"></i> Change</span>
                                                    <input type="file" name="video_bg" accept="image/*">
                                                </span>
                                <a href="#" class="btn btn-danger fileinput-exists bold uppercase"
                                   data-dismiss="fileinput"><i class="fa fa-trash"></i> Remove</a>
                            </div>
                        </div>
                        @if ($errors->has('video_bg'))
                            <div class="error">{{ $errors->first('video_bg') }}</div>
                        @endif
                    </div>
                </div>

                <div class="form-group">



                    <div class="form-group{{ $errors->has('about_video') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong style="text-transform: uppercase;">Youtube Video</strong></label>
                        <div class="col-md-12">
                            <input type="text" class="form-control form-control-lg"  name="about_video" value="{{$basic->about_video}}">
                            @if ($errors->has('about_video'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('about_video') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <br>


                    <div class="form-group{{ $errors->has('video_title') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong style="text-transform: uppercase;"> Video Section Title</strong></label>
                        <div class="col-md-12">
                            <input type="text" class="form-control form-control-lg" name="video_title" value="{{$basic->video_title}}">
                            @if ($errors->has('video_title'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('video_title') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <br>


                    <div class="form-group{{ $errors->has('video_details') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong style="text-transform: uppercase;"> Video Section Details</strong></label>
                        <div class="col-md-12">
                            <textarea name="video_details" class="form-control form-control-lg" rows="5">{{$basic->video_details}}</textarea>
                            @if ($errors->has('video_details'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('video_details') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <br>


                </div>

            </div>
            <div class="card-footer bg-white">
                <button class="btn btn-primary btn-block btn-lg" type="submit">Update About</button>
            </div>


        </form>
    </div>



@stop
@section('script')
    <script type="text/javascript" src="{{asset('assets/admin/js/nicEdit-latest.js')}}"></script>

    <script type="text/javascript">
        bkLib.onDomLoaded(function () {
            new nicEditor({fullPanel: true}).panelInstance('area1');
        });
    </script>
@stop